﻿//////////////////////////////////////////////
// ShaderManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "Shader.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

// Standards
#include <unordered_map>
#include <mutex>
#include <string>
	
/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ShaderManager final : public Manager<Shader>, public nkCommon::MaybeSingletonClass<ShaderManager>
	{
		public :

			// Available default shaders names
			inline static const nkMemory::StringView DEFAULT_EMPTY_SHADER = "NILKINS_EMPTY_SHADER" ;
			inline static const nkMemory::StringView DEFAULT_POSITION_SHADER = "NILKINS_POSITION_SHADER" ;
			inline static const nkMemory::StringView DEFAULT_UV_SHADER = "NILKINS_UV_SHADER" ;
			inline static const nkMemory::StringView DEFAULT_NORMAL_SHADER = "NILKINS_NORMAL_SHADER" ;
			inline static const nkMemory::StringView DEFAULT_UV_NORMAL_SHADER = "NILKINS_UV_NORMAL_SHADER" ;

		private :

			// Constructors
			ShaderManager (bool isSingleton) noexcept ;
			ShaderManager (System* system) noexcept ;

			// Customization
			virtual void _setupResource (Shader* resource) override ;

		private :
		
			// Id counter
			unsigned int _shaderCounter ;

		private :

			friend class nkCommon::MaybeSingletonClass<ShaderManager> ;
			friend class System ;
	} ;
}